from tkinter import *
import serial
from matplotlib.backends.backend_tkagg import (FigureCanvasTkAgg, NavigationToolbar2Tk)
from matplotlib.backend_bases import key_press_handler
from matplotlib.figure import Figure
import matplotlib.pyplot as plt
import numpy as np
from datetime import datetime
import os
import csv


#
# parameters of the serial communication
#

port = '/dev/ttyUSB0'
#port='COM13'
baudRate=9600



#
# Global variables
#


length_window=200 #number of values to plot
pressure1=np.zeros(length_window)  #List of the received pressure values
pressure2=np.zeros(length_window)
pressure3=np.zeros(length_window)
timeL=np.zeros(length_window) #List of time stamp received

plot_pressure=True
saving=False

p1=0.0
p2=0.0
p3=0.0
time=0.0


def idle(parent):
    #
    # idle routine
    #
    global p1, p2, p3, time, pressure1, pressure2, pressure3, timeL
    
    #Detects the framing
    start=decode_string()
    if(start=="P1"):
        p1=decode_float()
        p2=decode_float()
        p3=decode_float()
        timeInt=decode_int()
        time=float(timeInt/1000)

      #Update the variable labels of th interface
        v_p1.set(p1)
        v_p2.set(p2)
        v_p3.set(p3)

        # Add the received values to the lists
        if(p1>=0 and p2>=0 and p3>=0 and time>=0): #Ensure that all the data were cotrrectly received
            print(p1,p2, p3, time)
            pressure1=np.roll(pressure1,-1) #shift all the values to the left
            pressure1[-1]=p1 #add the value as last element
            pressure2=np.roll(pressure2,-1) #shift all the values to the left
            pressure2[-1]=p2 #add the value as last element
            pressure3=np.roll(pressure3,-1) #shift all the values to the left
            pressure3[-1]=p3 #add the value as last element
            timeL=np.roll(timeL,-1) #shift all the values to the left
            timeL[-1]=time #add the value as last element
            if(saving):
                save_csv()#Save at each step the values in a csv file
            if(plot_pressure==True):#Update the plots
                try:
                    update_graphs()
                except:
                    print("Reinitialisation of the data required")
        else: 
            print("Data missed")

            

    parent.after_idle(idle,parent)
    

def update_graphs():
    """ Update the graph real time """
    global pressure1, pressure2, pressure3, timeL, l_p1, l_p2, l_p3, a

    update_single_graph(timeL, pressure1, l_p1)
    update_single_graph(timeL, pressure2, l_p2)
    update_single_graph(timeL, pressure3, l_p3)
    a.set_xlim(timeL[-1]-30, timeL[-1]+10) #number of seconds before and after the last element of the time list
    
    canvas.draw()


def update_single_graph(x,y,l):
    """x, y: python lists of the same size"""
    l.set_data(x, y)

def save_csv():
    """Save the data in the csv file f_csv"""
    global f_csv, p1, p2, p3, time, path
    with open(path+"test_data.csv","a") as f_csv:
        writer = csv.writer(f_csv,delimiter=",")
        writer.writerow([time,p1, p2, p3])

def decode_int():
    """Reads an int sent by the arduino as a string and terminated by a '\n'"""
    global serial
    try:
        ser_bytes = ser.readline()
        decoded_bytes = (ser_bytes[0:len(ser_bytes)-2].decode("utf-8"))
        test =int(decoded_bytes)/1 # The value is effectively an int
        return(int(decoded_bytes))
    except:
        print("An error occured on the int serial transmission")
        return(-1)

def decode_float():
    """Reads a float sent by the arduino as a string and terminated by a '\n'"""
    global serial
    try:
        ser_bytes = ser.readline()
        decoded_bytes = (ser_bytes[0:len(ser_bytes)-2].decode("utf-8"))
        test =float(decoded_bytes)/1.0 # The value is effectively an int
        return(float(decoded_bytes))
    except:
        print("An error occured on the float serial transmission")
        return(-1.0)
        
def decode_string():
    """Reads an string sent by the arduino and terminated by a '\n'"""
    global serial
    try:
        ser_bytes = ser.readline()
        decoded_bytes = (ser_bytes[0:len(ser_bytes)-2].decode("utf-8"))
        return(decoded_bytes)
    except:
        print("An error occured on the String serial transmission")
        return("-1")


def reinit_b(event):
    """Reinitialise the pressure, pwm, and time lists (action of the  button)"""
    global timeL, pressure1, pressure2, pressure3
    pressure1=np.zeros(length_window)  #List of the received pressure values
    pressure2=np.zeros(length_window)
    pressure3=np.zeros(length_window)
    timeL=np.zeros(length_window) #List of time stamp received

def plot_pressure_b(event):
    """Change the value of the global variable plot_pressure (action of the  button)"""
    global plot_pressure
    plot_pressure = not plot_pressure
    if(plot_pressure):
        v_plot_p.set("Pause plot")
        print("plot pressure on")

    else: 
        v_plot_p.set("Plot pressure")
        print("plot pressure off")
    

def save_b(event):
    """Starts/stops the saving (action of the  button)"""
    global saving, path
    saving=not saving
    if(saving):
        v_save.set("Pause saving")
        #creates a new csv file
        now=datetime.now()
        folder_name=now.strftime("%Y-%m-%d_%H-%M")
        path='results/'+str(folder_name)
        print("saving data")
    else: 
        v_save.set("Save data")
        print("end of data saving")


#
# open serial port
#
ser = serial.Serial(port,baudRate)

#
# set up GUI
#
root = Tk()
root.title('Presure control interface (q to exit)')
root['bg']='white'
root.bind('q','exit')


#
# labels
#

fr_legends=Frame(root,borderwidth=2,relief=GROOVE)
fr_legends.pack(side=LEFT)

fr_labels=Frame(fr_legends,borderwidth=2,relief=GROOVE)
fr_labels.pack(side=TOP)

fr_label_p1=Frame(fr_labels,borderwidth=2,relief=GROOVE)
fr_label_p1.pack()
label_p1=Label(fr_label_p1, text="Pressure channel 1 =")
label_p1.pack(side=LEFT)
v_p1 = StringVar()
v_p1.set("0")
label_v_p1=Label(fr_label_p1, textvariable=v_p1 )
label_v_p1.pack(side=LEFT)


fr_label_p2=Frame(fr_labels,borderwidth=2,relief=GROOVE)
fr_label_p2.pack()
label_p2=Label(fr_label_p2, text="Pressure channel 2 =")
label_p2.pack(side=LEFT)
v_p2 = StringVar()
v_p2.set("0")
label_v_p2=Label(fr_label_p2, textvariable=v_p2)
label_v_p2.pack(side=LEFT)

fr_label_p3=Frame(fr_labels,borderwidth=2,relief=GROOVE)
fr_label_p3.pack()
label_p3=Label(fr_label_p3, text="Pressure channel 3 =")
label_p3.pack(side=LEFT)
v_p3 = StringVar()
v_p3.set("0")
label_v_p3=Label(fr_label_p3, textvariable=v_p3)
label_v_p3.pack(side=LEFT)


fr_legend_graph=Frame(fr_legends,borderwidth=2,relief=GROOVE)
fr_legend_graph.pack()
l=Label(fr_legend_graph, text="Channel 1", fg="blue")
l.pack(side=TOP)
l=Label(fr_legend_graph, text="Channel 2", fg="green")
l.pack(side=TOP)
l=Label(fr_legend_graph, text="Channel 3", fg="red")
l.pack(side=TOP)



#
# buttons
#
fr_button=Frame(fr_legends,borderwidth=2,relief=GROOVE)
fr_button.pack(side=TOP)

button_reinit=Button(fr_button, text='Reinitialize data')
button_reinit.bind("<Button-1>", reinit_b)
button_reinit.pack(side=TOP)

v_save = StringVar()
v_save.set("Save data")
button_reinit=Button(fr_button, textvariable=v_save)
button_reinit.bind("<Button-1>", save_b)
button_reinit.pack(side=TOP)

v_plot_p = StringVar()
v_plot_p.set("Plot pressure")
button_plot_p=Button(fr_button, textvariable=v_plot_p)
button_plot_p.bind("<Button-1>", plot_pressure_b)
button_plot_p.pack(side=TOP)

print("button set")

#
# canvas and figures
#
plt.ion() #Enable interactive plot
fig = Figure(figsize=(5, 4), dpi=100)
a =fig.add_subplot(111)
a.set_ylim(0, 1)
a.set_xlabel('Time (s)')
a.set_ylabel('Pressure')
#a.grid()
l_p1, =a.plot(0,0, 'b')
l_p2, =a.plot(0,0, 'g')
l_p3, =a.plot(0,0, 'r')


canvas = FigureCanvasTkAgg(fig, master=root)  # A tk.DrawingArea.
canvas.draw()
canvas.get_tk_widget().pack(side=TOP, fill=BOTH, expand=1)

toolbar = NavigationToolbar2Tk(canvas, root)
toolbar.update()
canvas.get_tk_widget().pack(side=TOP, fill=BOTH, expand=1)


print("canvas set")

#
# start idle loop
#
root.after(100,idle,root)
root.mainloop()
